//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: RTC interrupt occurs every 1 second with using external low-frequency clock as RTC clock source. P72 output level is inverted when interrupt occurs. 
//********************************************************
//******************************************
//Stack Pointer	=	0x23f (If use mq6821_x_startup.asm)
//Ram range = 0x40~0x23f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6821.h"
#include "MQ6812_REG_BIT.h"

void main()
{
	P7CR.bit.b2 =1;
 
	
    __asm("DI");
	POFFCR2.bit.b5	=	1;		// enable RTC
	EIRH.bit.b3	=	1;			// enable RTC interrupt
	__asm("EI");
	//=================================
	// to enable external low-frequency crystal, you need to check the checkbox 'ext low OSC' when programming
	//          |---------> //    programming by IDE : Project -> Pin Setting -> check 'ext low OSC'
	//================================
	P0FC.bit.b0 = 	1;			//P00 switch to External clock Pin
	P0CR.bit.b0 = 	0;			
	P0CR.bit.b1 = 	0;			//P00 P01 input
	FSCTRL.bit.b0 = 1;
		
	SYSCR2.bit.b5	=	1;		// NORMAL1 mode to NORMAL2 mode
	SYSCR2.bit.b4	=	1;		// NORMAL2 mode to SLOW2 mode
	SYSCR2.bit.b7	=	0;		// SLOW2 mode to SLOW1 mode
	
	
	RTCCR.byte		=	0x00;	//[-,-,-,-	RTCSEL[3],RTCRUN]
								// set RTCSEL = 010 ,  2^13/fs
								// RTCSEL	select the interrupt generation interval	
								// 000:2^15/fs(1.000[s]@fs=32.768kHz)
								// 000:2^14/fs(0.500[s]@fs=32.768kHz)
								// 000:2^13/fs(0.250[s]@fs=32.768kHz)
								// 000:2^12/fs (125.0[ms]@fs=32.768kHz)
								// 000:2^11/fs(62.50[ms]@fs=32.768kHz)
								// 000:2^10/fs(31.25[ms]@fs=32.768kHz)
								// 000:2^9/fs(15.62[ms]@fs=32.768kHz)
								// 000:2^8/fs(7.81[ms]@fs=32.768kHz)

								// RTCRUN	enables/disables the real time clock operation
								// 0: disable
								// 0: enable

    RTCCR.bit.b0	=	1;		// start RTC
	while(1)
	{
		WDCDR.byte = 0x4e;			//clear WDT    
	}    
	
	
}